function varargout = findname(THIS,varargin)
% findname  Find names of variables, shocks, or parameters by their descriptors.
%
% Syntax
% =======
%
%     [NAME,NAME,...] = findname(M,DESC,DESC,...)
%     [LIST,LIST,...] = findname(M,'-rexp',REXP,REXP,...)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object in which the names will be searched for.
%
% * `DESC` [ char ] - Variable, shock, or parameter descriptors that will
% be searched for.
%
% * `REXP` [ char ] - Regular expressions that will be matched against
% variable, shock, and parameter descriptors.
%
% Output arguments
% =================
%
% * `NAME` [ char ] - First name found with the descriptor `DESC`.
%
% * `LIST` [ cellstr ] - List of names whose descriptors match the regular
% expression `REXP`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin < 2
    return
end

[varargout{1:nargout}] = myfind(THIS,'findname',varargin{:});

end
