function varargout = findeqtn(THIS,varargin)
% findeqtn  Find equations by the labels.
%
% Syntax
% =======
%
%     [EQTN,EQTN,...] = findeqtn(M,LABEL,LABEL,...)
%     [LIST,LIST,...] = findeqtn(M,'-rexp',REXP,REXP,...)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object in which the equations will be searched
% for.
%
% * `LABEL` [ char ] - Equation label that will be searched for.
%
% * `REXP` [ char ] - Regular expressions that will be matched against
% equation labels.
%
% Output arguments
% =================
%
% * `EQTN` [ char ] - First equation found with the label `LABEL`.
%
% * `LIST` [ cellstr ] - List of equations whose labels match the regular
% expression `REXP`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin < 2
    return
end

[varargout{1:nargout}] = myfind(THIS,'findeqtn',varargin{:});

end
