function disp(THIS)
% DISP  [Not a public function] Display method for model objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

thisclass = class(THIS);
nalt = size(THIS.Assign,3);

if THIS.linear
    thislinear = 'linear';
else
    thislinear = 'non-linear';
end

if isempty(THIS.Assign)
    fprintf('\tempty %s object\n',thisclass);
else
    [ans,index] = isnan(THIS,'solution'); %#ok<NOANS,ASGLU>
    fprintf('\t%s %s object: %g parameterisation(s)\n', ...
        thislinear,thisclass,nalt);
    nsol = sum(~index);
    if nsol == 0
        howmany = 'no parameterisation';
    else
        howmany = sprintf('a total of %g parameterisation(s)',nsol);
    end
    fprintf('\tsolution(s) available for %s\n',howmany);
end
disp@userdataobj(THIS);
disp(' ');

end