function this = alter(this,n)
% alter  Expand or reduce number of alternative parameterisations.
%
% Syntax
% =======
%
%     M = alter(M,N)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object in which the number of paremeterisations
% will be changed.
%
% * `N` [ numeric ] - New number of parameterisations.
%
% Output arguments
% =================
%
% * `M` [ model ] - Model object with the new number of parameterisations.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

nalt = length(this);
if n == nalt
    return
elseif n > nalt
    % Expand number of alternative params.
    % Get an object with the last parameterisation.
    s = struct();
    s.type = '()';
    s.subs = {nalt};
    last = subsref(this,s);
    % Assign the last parameterisation to nalt+1 : n.
    s = struct();
    s.type = '()';
    s.subs = {nalt+1 : n};
    this = subsasgn(this,s,last);
else
    % Reduce number of alternative params.
    s = struct();
    s.type = '()';
    s.subs = {1:n};
    this = subsref(this,s);
end

end