function index = affectedeqtn(m,ialt,force)
% AFFECTEDEQTN  [Not a public function] Equations affected by parameter changes since last system.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

index = true(size(m.eqtn));

% User forces all equations to be selected.
if nargin > 2 && ~force
    return
end

% If deriv0 does not exist we must select all equations.
if ~any(any(m.deriv0.f(m.eqtntype <= 2,:)))
    return
end

% Changes in steady states and parameters.
changed = m.Assign(1,:,ialt) ~= m.Assign0 ...
    & (~isnan(m.Assign(1,:,ialt)) | ~isnan(m.Assign0));
if m.linear
    % Only parameter changes matter in linear models.
    changed = changed & m.nametype == 4;
end

% Affected equations.
nname = length(m.name);
occur0 = m.occur(:,(m.tzero-1)*nname+(1:nname));
index = any(occur0(:,changed),2).';

end