function [assignpos,stdcorrpos,assignval,stdcorrval,type] = ...
    mynameposition(this,input,varargin)
% mynameposition  [Not a public function] Name position in the Assign or stdcorr vector.
%
% Backend IRIS function.
% No help provided.

% If `input` is a single char it can be a regular expression, and
% `assignpos` and `stdcorrpos` are logical indices of the same size as the
% `Assign` and `stdcorr` properties.
%
% If `input` is a cellstr (also size 1-by-1), then `assignpos` and
% `stdcorrpos` are the size of `input` with pointers to the `Assign` and
% `stdcorr` positions or NaNs.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if iscellstr(input)
    
    % Input is a cellstr of names. Return an array of the same size
    % with pointers to the positions, or NaNs.
    n = length(input);
    assignpos = nan(1,n);
    stdcorrpos = nan(1,n);
    type = nan(1,n);
    for i = 1 : n
        [assignindex,stdcorrindex] = xxnameindex(this,input{i});
        if any(assignindex)
            assignpos(i) = find(assignindex);
            type(i) = this.nametype(assignpos(i));
        end
        if any(stdcorrindex)
            stdcorrpos(i) = find(stdcorrindex);
            type(i) = 4;
        end
    end
    if any(strcmp(varargin,'error'))
        found = ~isnan(assignpos) | ~isnan(stdcorrpos);
        if any(~found)
            utils.error('model','#Name_not_exists',input{~found});
        end
    end
    
elseif ischar(input)
    
    % Single input can be regular expression. Return all possible
    % matches.
    [assignpos,stdcorrpos] = xxnameindex(this,input);
    
else
    
    assignpos = [];
    stdcorrpos = [];
    
end

if nargout > 2
    assignval = nan(size(assignpos));
    stdcorrval = nan(size(stdcorrpos));
    assignval(~isnan(assignpos)) = ...
        this.Assign(1,assignpos(~isnan(assignpos)),:);
    stdcorrval(~isnan(stdcorrpos)) = ...
        this.stdcorr(1,stdcorrpos(~isnan(stdcorrpos)),:);
end

end

% Subfunctions.

%**************************************************************************
function [assignindex,stdcorrindex] = xxnameindex(this,string)

assignindex = false(1,size(this.Assign,2));
stdcorrindex = false(1,size(this.stdcorr,2));

if (length(string) >= 5 && strncmp(string,'std_',4)) ...
    || (length(string) >= 9 && strncmp(string,'corr_',5))

    % Position of a std or corr name.
    stdcorrindex = mystdcorrindex(this,string);
    
else
    
    % Position of a parameter or steady state name.
    assignindex = strfun.strcmporregexp(this.name,string);

end

end
% xxnameindex().