function d = emptydb(this)
% emptydb  Create model-specific database with variables, shocks, and parameters.
%
% Syntax
% =======
%
%     d = emptydb(m)
%
% Input arguments
% ================
%
% * `m` [ model | bkwmodel ] - Model or bkwmodel object for which the empty
% database will be created.
%
% Output arguments
% =================
%
% * `d` [ struct ] - Database with an empty tseries object for each
% variable and each shock, and an empty array for each parameter.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

x = cell(size(this.name));
x(this.nametype <= 3) = {tseries()};
x(this.nametype == 4) = {[]}; 
d = cell2struct(x,this.name,2);

end