function X = subsref(THIS,S)

if S(1).type == '.'
    name = S(1).subs;
    assignpos = mynameposition(THIS,{name});
    if ~isnan(assignpos)
        % Regular parameter or steady state.
        X = THIS.Assign(1,assignpos);
    else
        utils.error('model', ...
            'This name does not exist in the esteq object: ''%s''.', ...
            name);
    end
    S(1) = [];
    if ~isempty(S)
        X = subsref(X,S);
    end
end

end
