function THIS = myparse(THIS,eqtn,parameter)

% Assign equations.
THIS.eqtn = eqtn; 

% Remove blanks and put equations in implicit form.
docleanup();

% Read list of observables (variables).
doreadobservables();

% Add list of parameters.
doaddparameters();

% Replace parameter names and observable names with p(...) and x(...).
dosubstitute();

% Vectorise *, /, \, ^ operators.
eqtn = strfun.vectorise(eqtn);

% Find max lag and max lead.
dofindmaxlaglead();

% Create initial vector of parameter values; populate unused metaobj
% properties.
doassign();

% Create anonymous function for all equations.
doanonymous();

% Nested functions.

%**************************************************************************
    function docleanup()
        eqtn = regexprep(eqtn,';$','','once');
        eqtn = regexprep(eqtn,'\s+','');
        eqtn = regexprep(eqtn,'=(.*)','-($1)','once');
        eqtn = regexprep(eqtn,'.$','$0;','once');
    end        
% docleanup().

%**************************************************************************
    function doreadobservables()
        list = regexp(eqtn,'\<[a-zA-Z]\w*\>(?!\()','match');
        list = [list{:}];
        list = unique(list);
        list = setdiff(list,parameter);
        THIS.name = list;
        THIS.nametype = 1*ones(1,length(list));
    end
% doreadobservables().

%**************************************************************************
    function doaddparameters()
        THIS.name = [THIS.name,parameter];
        THIS.nametype = [THIS.nametype,4*ones(1,length(parameter))];
    end
% doaddparameters().

%**************************************************************************
    function dosubstitute()
        for ii = find(THIS.nametype == 4)
            pattern = ['\<',THIS.name{ii},'\>'];
            replace = sprintf('?(%g)',ii);
            eqtn = regexprep(eqtn,pattern,replace);
        end
        eqtn = regexprep(eqtn,'\{0\}','');
        eqtn = regexprep(eqtn,'\{(\d+)\}','\{+$1\}');
        for ii = find(THIS.nametype == 1)
            pattern = ['\<',THIS.name{ii},'\>\{([\+\-]\d+)\}'];
            replace = ['#(',sprintf('%g',ii),',t$1)'];
            eqtn = regexprep(eqtn,pattern,replace);
            pattern = ['\<',THIS.name{ii},'\>'];
            replace = ['#(',sprintf('%g',ii),',t)'];
            eqtn = regexprep(eqtn,pattern,replace);
        end
        eqtn = strrep(eqtn,'?','p');
        eqtn = strrep(eqtn,'#','x');
    end
% dosubstitute().

%**************************************************************************
    function dofindmaxlaglead()
        THIS.maxlag = 0;
        THIS.maxlead = 0;
        tok = regexp(eqtn,',t([\+\-]\d+)\)','tokens');
        try %#ok<TRYNC>
            % Unwrap equations.
            tok = [tok{:}];
            % Unwrap matches.
            tok = [tok{:}];
            tok = char(tok);
            shift = str2num(tok); %#ok<ST2NM>
            shift(end+1) = 0;
            THIS.maxlag = abs(min(shift));
            THIS.maxlead = max(shift);
        end
    end
% dofindmaxlaglead().

%**************************************************************************
    function doelementwise()
        eqtn = regexprep(eqtn,'(?<!\.)(\*`\\`/|\^)','.$1');
    end
% doelementwise().

%**************************************************************************
    function doassign()
        THIS.Assign = nan(size(THIS.name));
        THIS.namelabel = cell(size(THIS.name));
        THIS.namelabel(:) = {''};
        THIS.log = false(size(THIS.name));
        THIS.stdcorr = zeros(1,0);
    end
% doassign().

%**************************************************************************
    function doanonymous()
        THIS.eqtneval = str2func(['@(x,p,t) [',eqtn{:},']']);
    end
% doanonymous().

end