function [PSTAR,objstar,COV,HESS,THIS] = estimate(THIS,D,RANGE,E,varargin)
% estimate  Estimate parameters in esteq object.

opt = passvalopt('estimateobj.myestimate',varargin{:});

%**************************************************************************

s = myestimstruct(THIS,E,0,'warning');
s.data = mydatarequest(THIS,D,RANGE);
s.assign = THIS.Assign;
s.stdcorr = THIS.stdcorr;
s.minusloglik = @myprederr;
s.loglikopt = struct();

list = fieldnames(opt);
for i = 1 : length(list);
    s.(list{i}) = opt.(list{i});
end

[THIS,pstar,objstar,HESS,boundhit] = myestimate(THIS,s);

np = length(s.p0);
COV = nan(np);
COV(~boundhit,~boundhit) = inv(HESS{1}(~boundhit,~boundhit));

PSTAR = cell2struct(num2cell(pstar),s.plist,2);

end
