function this = symbdiff(this)
% symbdiff  Differentiate model equations symbolically.
%
% Backend IRIS function.
% No help provided.

%**************************************************************************

eqtn = regexprep(this.eqtnEval,'x\((\d+),t-(\d+)\)','x$1_$2');
neqtn = length(eqtn);
this.deqtn = cell(size(eqtn));

for eq = 1 : neqtn
   occur = this.occur(eq,this.nametype == 1,:);
   [name,time] = find(permute(occur,[2,3,1]));
   name = name.';
   time = time.';
   nocc = length(name);
   wrt = cell([1,nocc]);
   for i = 1 : nocc
      wrt{i} = sprintf('x%g_%g',name(i),time(i)-1);
   end
   z = sydney(eqtn{eq});
   z = diff(z,wrt,1);
   z = reduce(z);
   this.deqtn{eq} = char(z);
end

this.deqtn = regexprep(this.deqtn,'x(\d+)_(\d+)','x($1,t-$2)');

end