function this = metasystem(this)
% metasystem  Information for setting up first-order system matrices.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes & Troy Matheson.

%**************************************************************************

nt = size(this.occur,3);
maxlag = nt - 1;
n = sum(this.nametype == 1);

this.systemid = [];
for t = 0 : maxlag-1
   this.systemid = [this.systemid,find(this.nametype == 1) - 1i*t];
end

this.systemkeep = true(size(this.systemid));
for i = find(this.nametype == 1)
   thismaxlag = max([1,find(any(this.occur(:,i,:),1),1,'last')-1]);
   index = real(this.systemid) == i ...
      & abs(imag(this.systemid)) > thismaxlag-1;
   if any(index)
      this.systemkeep(index) = false;
   end
end

this.systemid = this.systemid(this.systemkeep);

% Convert x to a: a(1:nn) = x(systemxi)
% where x is n-by-(maxlag+1).
nn = sum(this.systemkeep);
this.systemxi = nan([1,nn]);
this.systemlog = false([1,nn]);
t = maxlag + 1;
for i = 1 : nn
   temp = false([n,maxlag + 1]);
   realid = real(this.systemid(i));
   imagid = imag(this.systemid(i));
   temp(realid,t+imagid) = true;
   this.systemxi(i) = find(temp);
   this.systemlog(i) = this.log(realid);
end

end