function varargout = get(this,varargin)
% get  Query bkwmodel object properties.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('x',@(x) isa(x,'bkwmodel'));
P.addRequired('name',@iscellstr);
P.parse(this,varargin);

%**************************************************************************

varargout = cell(size(varargin));
varargin = strtrim(varargin);
n = length(varargin);
flag = true([1,n]);
for iarg = 1 : n
   query = lower(varargin{iarg});
   [varargout{iarg},flag(iarg)] = specget(this,query);
end

% Report invalid queries.
if any(~flag)
   utils.error('bkwmodel', ...
      'This is not a valid bkwmodel object query: ''%s''.', ...
      varargin{~flag});
end

end