function varargout = subsref(this,s)
% subsref  Subscripted reference for VAR objects.
%
% Syntax to retrieve VAR object with subset of parameterisations
% ===============================================================
%
%     v(index)
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object.
%
% * `index` [ numeric | logical ] - Index of requested parameterisations.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if any(strcmp(s(1).type,{'()','{}'})) ...
        && length(s(1).subs) == 1
    nalt = length(this);
    if ischar(s(1).subs) && strcmp(s(1).subs{1},':');
        index = 1 : nalt;
    else
        index = s(1).subs{1};
    end
    this = mysubsalt(this,index);
    if length(s) == 1
        varargout{1} = this;
    else
        [varargout{1:nargout}] = subsref(this,s(2:end));
    end
else
    [varargout{1:nargout}] = builtin('subsref',this,s);
end

end