function THIS = setnames(THIS,YNAMES,ENAMES)
% setnames  [Not a public function] Set names of variables and residuals.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

NY = size(THIS.A,1);

if ~exist('YNAMES','var') || isempty(YNAMES)
    YNAMES = @(n) sprintf('y%g',n);
elseif ischar(YNAMES)
    YNAMES = regexp(YNAMES,'\w+','match');
elseif ~iscellstr(YNAMES) ...
        && (~isa(YNAMES,'function_handle') || NY == 0)
    utils.error('VAR', ...
        'Invalid type of input for VAR variable names.');
end

if ~exist('ENAMES','var') || isempty(ENAMES)
    ENAMES = @(yname,n) sprintf('res_%s',yname);
elseif ischar(ENAMES)
    ENAMES = regexp(ENAMES,'\w+','match');    
elseif ~iscellstr(ENAMES) && ~isa(ENAMES,'function_handle')
    utils.error('VAR', ...
        'Invalid type of input for VAR residual names.');
end

if iscellstr(YNAMES) && iscellstr(ENAMES) ...
        && (length(YNAMES) ~= length(ENAMES))
    utils.error('VAR', ...
        'Incorret number of VAR variables names or residual names.');
end

if NY > 0 && NY ~= length(YNAMES)
    utils.error('VAR', ...
        'Incorret number of VAR variables names.');
end

%**************************************************************************

if iscellstr(YNAMES)
    THIS.ynames = YNAMES(:).';
elseif isa(YNAMES,'function_handle') && NY > 0
    THIS.ynames = cell(1,NY);
    for i = 1 : NY
        THIS.ynames{i} = YNAMES(i);
    end
end
NY = length(THIS.ynames);

if iscellstr(ENAMES)
    THIS.enames = ENAMES(:).';
elseif isa(ENAMES,'function_handle')
    THIS.enames = cell(1,NY);
    for i = 1 : NY
        THIS.enames{i} = ENAMES(THIS.ynames{i},i);
    end
end

end