function this = myschur(this)
% myschur  [Not a public function] Triangular representation of VAR.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[ny,p,nalt] = size(this.A);
p = p / max(ny,1);

if p == 0
    this.T = zeros(ny,ny,nalt);
    this.U = repmat(eye(ny),[1,1,nalt]);
    this.eigval = zeros(1,ny,nalt);
    return
end

A = zeros(ny*p,ny*p,nalt);
for ialt = 1 : nalt
    A(:,:,ialt) = [this.A(:,:,ialt);eye(ny*(p-1),ny*p)];
end

realsmall = getrealsmall();
this.U = nan(ny*p,ny*p,nalt);
this.T = nan(ny*p,ny*p,nalt);
this.eigval = nan(1,ny*p,nalt);
for ialt = 1 : nalt
    if any(any(isnan(A(:,:,ialt))))
        continue
    else
        [U,T] = schur(A(:,:,ialt));
        eigval = ordeig(T);
        eigval = eigval(:)';
        unstable = abs(eigval) > 1 + realsmall;
        unit = abs(abs(eigval) - 1) <= realsmall;
        clusters = zeros(size(eigval));
        clusters(unstable) = 2;
        clusters(unit) = 1;
        [this.U(:,:,ialt),this.T(:,:,ialt)] = ordschur(U,T,clusters);
        this.eigval(1,:,ialt) = ordeig(this.T(:,:,ialt)).';
    end
end

end
