function this = myinfocrit(this)
% myinfocrit  [Not a public function] Compute information criteria.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

nalt = size(this.Omega,3);
nobs = sum(this.fitted,2);
nobs = permute(nobs,[1,3,2]);

if nobs == 0
    this.aic = nan(1,nalt);
    this.sbc = nan(1,nalt);
    return
end

logdetomg = nan(1,nalt);
for ialt = 1 : nalt
    logdetomg(ialt) = log(det(this.Omega(:,:,ialt)));
end
this.aic = logdetomg + 2./nobs * this.nhyper;
this.sbc = logdetomg + log(nobs)./nobs * this.nhyper;

end