function [flag,y,range,ynames,inputformat,varargin] = inputdata(THIS,varargin)
% inputdata  [Not a public data] Get input data and determine range, including i/c.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

flag = true;

if isstruct(varargin{1})
    inputformat = 'dbase';
    d = varargin{1};
    varargin(1) = [];
    if iscellstr(varargin{1})
        ynames = varargin{1};
        varargin(1) = [];
    elseif ischar(varargin{1})
        ynames = regexp(varargin{1},'\w+','match');
        varargin(1) = [];
    else
        ynames = THIS.ynames;
    end
    range = varargin{1};
    varargin(1) = [];
    userrange = range;
    [y,ans,range] = db2array(d,ynames,range); %#ok<NOANS,ASGLU>
    y = permute(y,[2,1,3]);
elseif istseries(varargin{1})
    inputformat = 'tseries';
    y = varargin{1};
    range = varargin{2};
    userrange = range;
    varargin(1:2) = [];
    [y,range] = rangedata(y,range);
    y = permute(y,[2,1,3]);
    ynames = THIS.ynames;
else
    % Invalid input data.
    y = [];
    range = [];
    ynames = THIS.ynames;
    inputformat = '';
    varargin = {};
    flag = false;
end

if isequal(userrange,Inf)
    sample = ~any(any(isnan(y),3),1);
    first = find(sample,1);
    last = find(sample,1,'last');
    y = y(:,first:last,:);
    range = range(first:last);
end

end
