function varargout = get(this,varargin)
% get  Query VAR object properties.
%
% Syntax
% =======
%
%     value = get(v,query)
%     [value,value,...] = get(v,query,query,...)
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object.
%
% * `query` [ char ] - Name of the queried property.
%
% Output arguments
% =================
%
% * `value` [ ... ] - Value of the queried property.
%
% Valid queries on VAR objects
% =============================
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[varargout{1:nargout}] = utils.get(this,varargin{:});

end
