function [Phi,Psi,s,c] = ferf(this,time)
% ferf  Forecast error response function.
%
% Syntax
% =======
%
%     [Phi,Psi,s,c] = ferf(v,nper)
%     [Phi,Psi,s,c] = ferf(v,range)
%
% Output arguments
% =================
%
% * `Phi` [ numeric ] - Response function matrices.
%
% * `Psi` [ numeric ] - Cumulative response function matrices.
%
% * `s` [ tseries ] - Response function time series.
%
% * `c` [ tseries ] - Cumulative response function time series.
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object for which the forecast error response function
% will be computed.
%
% * `nper` [ numeric ] - Number of periods.
%
% * `range` [ numeric ] - Date range.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% Tell if `time` is `nper` or `range`.
if length(time) == 1 && round(time) == time && time > 0
   range = 1 : time;
else
   range = time(1) : time(end);
end
nper = length(range);

%**************************************************************************

% Compute VMA matrices.
Phi = timedom.var2vma(this.A,[],nper);

if nargout > 1
   % Cumulative responses.
   Psi = cumsum(Phi,3);
   if nargout > 2
      % Create tseries objects.
      s = permute(Phi,[3,1,2,4]);
      s = tseries(range,s);
      if nargout > 3
         c = permute(Psi,[3,1,2,4]);
         c = replace(s,c);
      end
   end
end

end

