function error(code,list,varargin)
% error  [Not a public function] Look-up table for VAR errors.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

switch code
   case 1
      msg = 'Error when evaluating parameter constraints: %s';
   case 7
      msg = 'Insufficient data to simulate.';
   case 8
      msg = 'Portmonteau test order must be higher than VAR order.';
   case 9
      msg = 'VARs with parameter restrictions and within-sample NaNs not implemented.';
   case 10
      msg = 'Insufficient number of observations.';
   case 15
      msg = 'Unable to print reduced-form VAR as model code.';
   case 16
      msg = 'Size of %s or conditions must match size of VAR.';
   case 17
      msg = 'Unable to run VAR/%s with multiple params or data sets in the present context.';
   case 18
      msg = 'Function %s cannot be applied to reduced-form VARs.';
   case 19
      msg = 'Function %s cannot be applied to VAR with multiple parameterisations.';
   case 20
      msg = 'Function %s cannot be run with multiple data sets.';
   case 21
      msg = 'Invalid size of the dummy observation matrix.';
   case 22
      msg = 'Numbers of exogenised and endogenised data points do not match in period%s.';
   case 23   
      msg = 'Input argument ny does not match number of variables.';
   case 24
     msg = 'Number of parameterisations and number of data sets must match.';    
   case 25
      msg = 'Co-integrated VARs with exogenous blocks not implemented.';
   case 26
      msg = 'Order of exogenous block must match order of currently estimated VAR.';
   case 27
      msg = 'Cannot use Inf for range in %s.';
   case 28
      msg = 'Cannot create names for VAR residuals.';
   case 29
      msg = 'Cannot create names for VAR variables.';
   case 30
      msg = 'Cannot apply %s to reduced-form VAR.';
   case 31
      msg = 'Number of input series must match number of VAR variables.';
   case 32
      msg = 'All data sets must have the same structure of missing observations.';
   case 33
      msg = 'LR-tested pairs of VARs must have the same periods fitted.';     
   case 34
      msg = 'Cannot resample on an empty range.';
   case 35
      msg = ['Error setting up VAR restrictions for matrix %s. ',...
             'Size of the matrix must be %s.'];
   case 38
      msg = 'This is not a modifiable VAR object property: ''%s''.';
   case 39
      msg = 'FPRINTF and SPRINTF format strings must contain ''%%+'': ''%s''.';
end

if nargin == 1
   list = {};
elseif ~iscell(list)
   list = {list};
end

printmsg('VAR','error',msg,list,code);

end
