function this = backward(this)
% backward  Backward VAR process.
%
% Syntax
% =======
%
%     v = backward(v)
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object.
%
% Output arguments
% =================
%
% * `v` [ VAR ] - VAR object with the VAR process reversed in time.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[ny,p,nalt] = sizeof(this);

index = isstationary(this);
for ialt = 1 : nalt
    if index(ialt)
        [T,R,K,Z,H,D,U,Omega] = sspace(this,ialt);
        % 0th and 1st order autocovariance matrices of stacked y vector.
        C = covfun.acovf(T,R,[],[],[],[],U,Omega,this.eigval(1,:,ialt),1);
        A = transpose(C(:,:,2)) / C(:,:,1);
        Q = A*C(:,:,2);
        Omega = C(:,:,1) + A*C(:,:,1)*transpose(A) - Q - transpose(Q);
        A = A(end-ny+1:end,:);
        A = reshape(A,[ny,ny,p]);
        A = A(:,:,end:-1:1);
        this.A(:,:,ialt) = A(:,:);
        this.Omega(:,:,ialt) = Omega(end-ny+1:end,end-ny+1:end);
        this.K(:,ialt) = ...
            sum(poly.var2poly(this.A(:,:,ialt)),3)*mean(this,ialt);
    else
        % Non-stationary parameterisations.
        this.A(:,:,ialt) = NaN;
        this.Omega(:,:,ialt) = NaN;
        this.K(:,ialt) = NaN;
    end
end

if any(~index)
    VAR.warning(12,sprintf(' #%g',find(~index)));
end

[this.T,this.U,this.eigval] = schur(this.A);

end
