function [x,flag] = specget(this,query)
% specget  [Not a public function] Implement GET method for SVAR objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

x = [];
flag = true;
[ny,p,nalt] = sizeof(this);

switch query
    case 'b'
        x = this.B;
    case {'omg','omega','cove','covresiduals'}
        x = eye(ny);
        x = x(:,:,nalt);
        for ialt = 1 : nalt
            x(:,:,ialt) = x(:,:,ialt) * this.std(ialt) .^ 2;
        end
    case 'std'
        x = this.std;
    case {'a','a*'}
        if all(size(this.A) == 0)
            x = [];
        else
            x = poly.var2poly(this.A);
        end
        if isequal(query,'a*')
            x = -x(:,:,2:end,:);
        end
    case {'cumlong','cumlongrun'}
        C = sum(poly.var2poly(this.A),3);
        x = nan(ny,ny,nalt);
        for ialt = 1 : nalt
            if rank(C(:,:,1,ialt)) == ny
                x(:,:,ialt) = C(:,:,1,ialt)\this.B(:,:,ialt);
            else
                x(:,:,ialt) = pinv(C(:,:,1,ialt))*this.B(:,:,ialt);
            end
        end
    otherwise
        [x,flag] = specget@VAR(this,query);
end

end
