function this = mysubsalt(this,lhs,obj,rhs)
% mysubsalt  [Not a public function] Implement SUBSREF and SUBSASGN for SVAR objects with multiple params.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin == 2
    
    % Subscripted reference this(lhs).
    this = mysubs@VAR(this,lhs);
    this.B = this.B(:,:,lhs);
    this.std = this.std(:,lhs);
    
elseif nargin == 3 && isempty(obj)
    
    % Empty subscripted assignment this(lhs) = []
    this = mysubs@VAR(this,lhs,[]);
    this.B(:,:,lhs) = [];
    this.std(:,lhs) = [];
    
elseif nargin == 4 && strcmp(class(this),class(obj))

    % Proper subscripted assignment this(lhs) = obj(rhs)
    this = mysubs@VAR(this,lhs,obj,rhs);
    this.B(:,:,lhs) = obj.B(:,:,rhs);
    this.std(:,lhs) = obj.std(:,rhs);

else
    utils.error('SVAR','Invalid assignment to a SVAR object.');
end

end