function varargout = companion(this,varargin)
% companion  Matrices for first-order companion SVAR.
%
% Syntax
% =======
%
%     [A,B,K] = companion(s)
%
% Input arguments
% ================
%
% * `s` [ VAR ] - VAR object for which the companion
% matrices will be returned.
%
% Output arguments
% =================
%
% * `A` [ numeric ] - First-order companion transition matrix.
%
% * `B` [ numeric ] - First-order companion coefficient matrix at
% structural residuals.
%
% * `K` [ numeric ] - First-order companion constant vector.
%
% Description
% ============
%
% Example
% ========
%}


% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

[ny,p,nalt] = sizeof(this);

%**************************************************************************

[varargout{1:nargout}] = companion@VAR(this,varargin{:});

if nargout > 1
   varargout{2} = [this.B;zeros([ny*(p-1),ny,nalt])];
end

end
