function [c,Pc] = cc(C,x,Px)
% cc  Common components in observables.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes & Troy Matheson.

%**************************************************************************

meanonly = nargin < 3 || isempty(Px) || nargout < 2;
ny = size(C,1);
nalt = size(C,3);
nper = size(x,2);
ndata = size(x,3);
nloop = max([nalt,ndata]);
c = nan([ny,nper,nloop]);
Pc = nan([ny,ny,nper,nloop]);
for iloop = 1 : nloop
   if iloop <= nalt
      Ci = C(:,:,iloop);
      Cit = Ci';
   end
   if iloop <= ndata
      xi = x(:,:,iloop);
      if ~meanonly
         Pxi = Px(:,:,:,iloop);
      end
   end
   c(:,:,iloop) = Ci*xi;
   if ~meanonly
      for t = 1 : nper
         Pc(:,:,t,iloop) = Ci*Pxi(:,:,t)*Cit;
      end
   end
end

end
