function varargout = get(obj,varargin)
% get  [Not a public function] Template for GET methods.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

varargout = cell(size(varargin));
varargin = strtrim(varargin);
n = length(varargin);
flag = true(1,n);
for iarg = 1 : n
    func = [];
    query = strtrim(lower(varargin{iarg}));
    if ~isempty(query) && query(end) == '='
        query(end) = '';
    end
    tokens = regexp(query,'^(\w+)\((\w+)\)$','once','tokens');
    if ~isempty(tokens) && ~isempty(tokens{1})
        func = tokens{1};
        query = tokens{2};
    end
    [varargout{iarg},flag(iarg)] = specget(obj,query);
    if ~isempty(func)
        varargout{iarg} = feval(func,varargout{iarg});
    end
end

% Report invalid queries.
if any(~flag)
    utils.error(class(obj), ...
        'This is not a valid %s object query: ''%s''.', ...
        class(obj),varargin{~flag});
end

end