function [Phi,shksize] = srf(T,R,K,Z,H,D,U,Omg,nper,shksize) %#ok<INUSL>
% srf  [Not a public function] Shock response function (or VMA) for general state space.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 10
   shksize = 1;
end

%**************************************************************************

ny = size(Z,1);
[nx,nb] = size(T);
nf = nx - nb;
ne = size(R,2);

% Shock size.
shksize = shksize(:)';
if length(shksize) == 1 && ne ~= 1
   shksize = shksize(1,ones(1,ne));
end

% Add a zero pre-sample period for transition variables.
Phi = nan(ny+nx,ne,nper+1);
Phi(:,:,1) = 0;

% Simulate measurement shocks first, then transition shocks.
Phi(:,:,2) = [...
   H.*shksize(ones(1,ny),:);...
   R.*shksize(ones(1,nx),:);...
];
if ny > 0
   Phi(1:ny,:,2) = Phi(1:ny,:,2) + Z*Phi(ny+nf+1:end,:,2);
end

for t = 2 : nper
   Phi(ny+1:end,:,t+1) = T*Phi(ny+nf+1:end,:,t);
   if ny > 0
      Phi(1:ny,:,t+1) = Z*Phi(ny+nf+1:end,:,t+1);
   end
end

if ~isempty(U)
   for t = 1 : size(Phi,3)
      Phi(ny+nf+1:end,:,t) = U*Phi(ny+nf+1:end,:,t);
   end
end

end
