function [index,notfound,index1] = findnames(list,selection,pattern)
% findnames  Find positions of strings in a list.
%
% Syntax
% =======
%
%     [INDEX,NOTFOUND] = strfun.findnames(LIST,SELECTION)
%
% Input arguments
% ================
%
% * `LIST` [ cellstr ] - List of items that will be searched.
%
% * `ITEMS` [ cellstr | char ] List of items that will be looked for.
%
% Output arguments
% =================
%
% * `INDEX` [ numeric ] - Positions of `items` in `list`; if some `items`
% not found NaN filled in.
%
% * `NOTFOUND` [ cellstr ] - List of `items` not found in `list`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 3
   pattern = '\w+';
end

if ischar(list)
   list = regexp(list,pattern,'match');
end
list = list(:).';

if ischar(selection)
   selection = regexp(selection,pattern,'match');
end
selection = selection(:);

%**************************************************************************

index = nan(size(selection));
for i = 1 : length(selection(:))
   tmp = strcmp(list,selection{i});
   if any(tmp)
      index(i) = find(tmp,1);
   end
end
notfound = selection(isnan(index));
notfound = notfound(:).';

nlist = length(list);
nselection = length(selection);
list = list(ones([1,nselection]),:);
selection = selection(:,ones([1,nlist]));
[i,j] = find(strcmp(list,selection));
index1 = nan([1,nselection]);
index1(i) = j;

end
