function [strings,labels] = charlist2cellstr(x,sep)
% Convert character list to cell array of strings.

% The IRIS Toolbox 22009/02/20.
% Copyright 2007-2009 Jaromir Benes.
    
    if nargin < 2
        sep = ',;\n';
    end
    
%**************************************************************************
    
    x = strtrim(x);
    x = strfun.converteols(x);
    x = strfun.removecomments(x);
    
    % separators , ; end-of-line
    pattern = '(?<label>["''].*?["''])?\s*(?<string>[^"''#]*?)\s*(?=[#]|$)';
    pattern = strrep(pattern,'#',sep);
    y = regexp(x,pattern,'names');
    strings = {y(:).string};
    labels = {y(:).label};
    % remove double quotes from labels
    for i = 1 : length(labels)
        labels{i} = labels{i}(2:end-1);
    end
    
end
