classdef userinputobj < report.genericobj
    % USERINPUTOBJ  [Not a public class] Base class for report elements built on user input.
    %
    % Backend IRIS class.
    % No help provided.
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    properties
        userinput = '';
    end
    
    methods
        
        function THIS = userinputobj(varargin)
            THIS = THIS@report.genericobj(varargin{:});
            THIS.childof = {'report'};
            THIS.default = [THIS.default,{ ...
                'centering',false,@islogicalscalar,true, ...
                'verbatim',false,@islogicalscalar,true, ...                                
                }];
        end
        
        function [THIS,varargin] = specargin(THIS,varargin)
        end
        
        function [C,TEMPS] = speclatexcode(THIS)
            TEMPS = {};
            C = '';
            br = sprintf('\n');
            if ~isempty(THIS.title)
                C = [C,'\begin{tabular}{c}',br];
                C = [C,printcaption(THIS),br];
                C = [C,'\end{tabular}',br];
            end
            if isempty(THIS.userinput)
                return
            end
            if THIS.options.verbatim
                C = [C,'\begin{verbatim}'];
            elseif ~THIS.options.centering
                C = [C,'\begin{flushleft}'];
            end
            C = [C,br,THIS.userinput];
            if THIS.options.verbatim
                C = [C,br,'\end{verbatim}'];
            else
                if ~THIS.options.centering
                    C = [C,br,'\end{flushleft}'];
                end
            end
            C = [C,footnotetext(THIS)];
        end
        
    end
    
end