classdef texcommand < report.genericobj
    % texcommand  Include LaTeX command or commands in the report.
    %
    % Syntax
    % =======
    %
    %     P.texcommand(TEX)
    %
    % Input arguments
    % ================
    %
    % * `P` [ struct ] - Report object created by the [`report.new`](report/new)
    % function.
    %
    % * `TEX` [ char ] - Tex command or commands.
    %
    % Options
    % ========
    %
    % * `'separator='` [ char | *empty* ] - (Inheritable from parent objects)
    % LaTeX commands that will be inserted after the text.
    %
    % Description
    % ============
    %
    % Example
    % ========
    %
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    properties
    end
    
    methods
        
        function THIS = texcommand(varargin)
            THIS = THIS@report.genericobj(varargin{:});
            THIS.childof = {'report'};            
            THIS.default = [THIS.default,{ ...
                'separator','',@ischar,true, ...
                }];
        end
        
        function [this,varargin] = specargin(this,varargin)
        end
        
        function [C,TEMPS] = speclatexcode(THIS)
            TEMPS = {};
            C = THIS.caption;            
        end
        
    end
    
end