% publish  Compile PDF from report object.
%
% Syntax
% =======
%
%     P.publish(FNAME,...)
%
% Input arguments
% ================
%
% * `P` [ struct ] - Report object created by the `report.new` function.
%
% * `FNAME` [ char ] - File name under which the compiled PDF will be
% saved.
%
% Options
% ========
%
% * `'abstract='` [ char | *empty* ] - Abstract on the title page.
%
% * `'author='` [ char | *empty* ] - List of authors on the title page
% separated with `\and` or `\\`.
%
% * `'date='` [ char | *`'\today'`* ] - Date on the title page.
%
% * `'cleanup='` [ *`true`* | `false` ] - Delete all temporary files created
% when compiling the report.
%
% * `'epsToPdf='` [ char | *`Inf`* ] - Command line arguments for EPSTOPDF; if
% `Inf` system-dependent defaults are used.
%
% * `'fontEnc='` [ char | *`'T1'`* ] - \LaTeX\ font encoding.
%
% * `'makeTitle='` [ `true` | *`false`* ] - Produce title page (with title,
% author, date, and abstract).
%
% * `'paperSize='` [ `'a4paper'` | *`'letterpaper'`* ] - Paper size.
%
% * `'orientation='` [ *`'landscape'`* | `'portrait'` ] - Paper orientation.
%
% * `'preamble='` [ char | *empty* ] - \LaTeX\ commands that will be placed
% in the \LaTeX\ file preamble.
%
% * `'title='` [ char | *`Inf`* ] - Report title on the first page; `Inf`
% means the report caption specified in the [`report.new`](report/new)
% function will be used.
% 
% * `'timeStamp='` [ char | *`'datestr(now())'`* ] - String printed in the
% top-left corner of each page.
%
% * `'maxRerun='` [ numeric | *`5`* ] - Maximum number of times the \LaTeX\
% compiler will be run to resolve cross-references, etc.
%
% * `'scale='` [ numeric | *`0.8`* ] - Percentage of the total page area that
% will be used.
%
% Description
% ============
% 
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
