classdef pagebreak < report.genericobj
% pagebreak  Force page break.
%
% Syntax
% =======
%
%     P.pagebreak(...)
%
% Input arguments
% ================
%
% * `P` [ report ] - Report object created by the
% [`report.new`](report/new) function.
%
% Generic options
% ================
%
% See help on [generic options](report/Contents) in report objects.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

   methods

      function THIS = pagebreak(varargin)
         THIS = THIS@report.genericobj(varargin{:});
         THIS.childof = {'report'};
         THIS.default = [THIS.default,{}];
      end
      
      function [THIS,varargin] = specargin(THIS,varargin)
      end
      
      function THIS = setoptions(THIS,varargin)
          THIS = setoptions@report.genericobj(THIS,varargin{:});
          THIS.options.separator = '';
      end
      
      function [C,TEMPFILES] = speclatexcode(THIS) %#ok<MANU>
         TEMPFILES = {};
         C = '\clearpage';
      end
      
   end
   
end