function [C,HELPERFILES] = speclatexcode(THIS)
% SPECLATEXCODE  [Not a public function] LaTeX code for report/series data.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

HELPERFILES = {};
par = THIS.parent;
[x,time] = getdata(THIS,THIS.data, ...
    par.options.range,THIS.options.colstruct);
time = time.';
x = x(:,:);
C = '';
text = THIS.caption;
br = sprintf('\n');
nx = size(x,2);
for irow = 1 : nx
    if irow <= numel(THIS.options.marks)
        mark = THIS.options.marks{irow};
    else
        mark = '';
    end
    if irow > 1
        C = [C,br]; %#ok<AGROW>
    end
    C = [C, ...
        latexonerow(THIS,irow,time,x(:,irow),mark,text)]; %#ok<AGROW>
end

end