function [LGD,H,TIME,DATA,GRID] = plot(THIS,AX)
% PLOT  [Not a public function] Plot report/series data.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

par = THIS.parent;
switch char(THIS.options.plotfunc)
    case 'plotcmp'
        % axes(ax);
        [ans,H,rr,lhsrange,lhsdata,lhsgrid, ...
            rhsrange,rhsdata] = ...
            plotcmp(par.options.range,THIS.data{1}, ...
            'datetick',par.options.datetick, ...
            'dateformat',par.options.dateformat, ...
            THIS.options.plotoptions{:}); %#ok<NASGU,NOANS,ASGLU>
        TIME = lhsrange;
        DATA = lhsdata;
        GRID = lhsgrid;
    case {'predplot','plotpred'}
        [H,TIME,DATA,GRID] = plotpred( ...
            AX,par.options.range, ...
            THIS.data{1}{:,1}, ...
            THIS.data{1}{:,2:end}, ...
            'datetick',par.options.datetick, ...
            'dateformat',par.options.dateformat, ...
            THIS.options.plotoptions{:});
    otherwise
        [H,TIME,DATA,GRID] = tseries.gplot( ...
            THIS.options.plotfunc, ...
            AX,par.options.range,THIS.data{1}, ...
            'datetick',par.options.datetick, ...
            'dateformat',par.options.dateformat, ...
            THIS.options.plotoptions{:});
end

% Create legend entries.
ndata = size(DATA,2);
[LGD,exlude] = mylegend(THIS,ndata);
if exlude
    grfun.excludefromlegend(H);
end

end