function [LGD,exclude] = mylegend(THIS,NDATA)
% MYLEGEND  [Not a public function] Create legend entries for report/series.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

exclude = false;

% The default legend entries consist of the series caption and a
% mark, unless the entries are supplied through the `'legend='`
% option. These are used if the user set `'legend='` to Inf.
if isequal(THIS.options.legend,Inf)
    % Produce default legend entries.
    LGD = cell(1,NDATA);
    for i = 1 : NDATA
        name = THIS.caption;
        if i <= numel(THIS.options.marks)
            mark = THIS.options.marks{i};
        else
            mark = '';
        end
        if ~isempty(name) && ~isempty(mark)
            LGD{i} = [name,': ',mark];
        elseif isempty(mark)
            LGD{i} = name;
        elseif isempty(name)
            LGD{i} = mark;
        end
    end
elseif isequalwithequalnans(THIS.options.legend,NaN)
    % Exclude the series from legend.
    LGD = {};
    exclude = true;
else
    % Use user-suppied entries.
    LGD = cell(1,NDATA);
    if ischar(THIS.options.legend)
        THIS.options.legend = {THIS.options.legend};
    end
    THIS.options.legend = THIS.options.legend(:);
    n = min(length(THIS.options.legend),NDATA);
    LGD(1:n) = THIS.options.legend(1:n);
    LGD(n+1:end) = {''};
end

end