function C = latexdata(THIS,ROW,TIME,DATA,FORMAT,MARK,TEXT)
% LATEXDATA  [Not a public function] LaTeX code for data part of a table row.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

C = '';
par = THIS.parent;
isdates = isempty(par.options.colstruct);
if isempty(DATA)
    return
end
nper = numel(DATA);
highlightindex = false(1,nper);
for i = 1 : numel(THIS.options.highlight)
    highlightindex = highlightindex | ...
        round(TIME - THIS.options.highlight(i)) == 0;
end
c1 = cell(1,nper);
[year,per,freq] = dat2ypf(TIME);
obsoletewarning = false;

for t = 1 : nper
    c1{t} = report.series.sprintf(DATA(t),THIS.options);
    color = '';
    if highlightindex(t)
        color = 'highlightcolor';
    end
    c1{t} = report.series.makebox(c1{t},'',NaN,'',color);
    % Obsolete conditional formatting -- for bkw compatibility
    % only.
    if ~isempty(THIS.options.conditional)
        obsoletewarning = true;
        c1{t} = xxconditional(THIS.options.conditional, ...
            c1{t},DATA(t),TIME(t),MARK,TEXT,ROW);
    end
    a = doattributes();
    c1{t} = testnformat(THIS,c1{t},a);
end

for t = 1 : nper
    if ~isempty(FORMAT)
        if ~isempty(strfind(FORMAT,'?'))
            c1{t} = strrep(FORMAT,'?',c1{t});
        else
            c1{t} = [FORMAT,' ',c1{t}];
        end
    end
    C = [C,' & ',c1{t}]; %#ok<AGROW>
end

if obsoletewarning
    utils.warning('report', ...
        ['The option ''conditional'' in report/series is obsolete ', ...
        'and will be removed from future IRIS version. ', ...
        'Use ''condformat'' instead.']);
end

% Nested functions.

%**************************************************************************
    function A = doattributes()
        % Prepare an attribute struct for cond formatting.
        A = struct();
        A.value = DATA(t);
        A.rowvalues = DATA(:).';
        A.data = TIME(t);
        A.mark = MARK;
        A.text = TEXT;
        A.row = ROW;
        A.col = t;
        if ~isdates
            A.colname = par.options.colstruct(t).name{2};
        end
        A.year = year(t);
        A.per = per(t);
        A.freq = freq(t);
    end
% doattributes().

end

% OBSOLETE
% ========

% Subfunctions.

%**************************************************************************
function string = xxconditional(f,string,value,date,mark,text,row)
% Obsolete.
args = {string,value,date,mark,text,row};
for j = 1 : numel(f)
    try
        if ischar(f(j).test)
            test = eval(f(j).test);
        else
            n = xxfuncnargin(f(j).test);
            test = f(j).test(args{1:n});
        end
    catch %#ok<CTCH>
        test = false;
    end
    if islogicalscalar(test) && test
        if ischar(f(j).format)
            string = strrep(f(j).format,'$',string);
        else
            n = xxfuncnargin(f(j).format);
            string = f(j).format(args{1:n});
        end
        args{1} = string;
    end
end
string = ['{',string,'}'];
end
% xxconditional().

%**************************************************************************
% Obsolete.
function n = xxfuncnargin(f)
f = char(f);
header = regexp(f,'@\((.*?)\)','tokens','once');
if isempty(header) || isempty(header{1})
    n = 0;
    return
end
header = header{1};
inputs = regexp(header,'\w+','match');
n = length(inputs);
end
% xxfuncnargin().
