function [C,HELPERFILES] = speclatexcode(THIS)
% SPECLATEXCODE  [Not a public function] LaTeX code for report/band data.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

HELPERFILES = {};

par = THIS.parent;
time = par.options.range;
colstruct = par.options.colstruct;

[cdata,time] = getdata(THIS,THIS.data,time,colstruct);
ldata = getdata(THIS,THIS.low,time,colstruct);
hdata = getdata(THIS,THIS.high,time,colstruct);
cdata = cdata(:,:);
ldata = ldata(:,:);
hdata = hdata(:,:);

text = THIS.caption;
nl = sprintf('\n');
C = '';

nx = max([size(cdata,2),size(ldata,2),size(hdata,2)]);
for irow = 1 : nx
    cdatai = cdata(:,min(irow,end));
    ldatai = ldata(:,min(irow,end));
    hdatai = hdata(:,min(irow,end));
    if THIS.options.relative
        ldatai = cdatai + ldatai;
        hdatai = cdatai + hdatai;
    end
    datai = [cdatai,ldatai,hdatai];
    if irow <= numel(THIS.options.marks)
        mark = THIS.options.marks{irow};
    else
        mark = '';
    end
    C = [C,nl, ...
        latexonerow(THIS,irow,time,datai,mark,text)]; ...
        %#ok<AGROW>
end

end