function def = tseries()
% tseries  [Not a public function] Default options for tseries class functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

def = struct();

convert = { ...
    'function',[],@(x) isempty(x) || isa(x,'function_handle') || ischar(x), ...
    'missing',NaN,@(x) (ischar(x) && any(strcmpi(x,{'last'}))) || isnumericscalar(x), ...
    };

config = irisget();

dates = { ...
    'dateformat','config',config.validate.dateformat, ...
    'freqletters','config',config.validate.freqletters, ...
    'months','config',config.validate.months, ...
    'standinmonth','config',config.validate.standinmonth, ...
    'datetick',Inf,@(x) isnumeric(x) ...
    || any(strcmpi(x,{'yearstart','yearend','yearly'})) ...
    || isa(x,'function_handle'), ...
    };

def.acf = { ...
    'demean',true,@islogicalscalar, ...
    'order',0,@isnumericscalar, ...
    'smallsample',true,@islogicalscalar, ...
    };

def.bpass = { ...
    'addtrend',true,@islogicalscalar, ...
    'detrend',true,@islogicalscalar, ...
    'log',false,@islogicalscalar, ...
    'method','cf',@(x) ischar(x) && any(strcmpi(x,{'cf','hwfsf'})), ...
    'ttrend',[],@(x) isempty(x) || islogicalscalar(x), ...
    'unitroot',true,@islogicalscalar, ...
    'window','hamming',@(x) ischar(x) && any(strcmpi(x,{'hamming','hanning','none'})), ...
    };

def.chowlin = { ...
    'constant',true,@islogicalscalar, ...
    'log',false,@islogicalscalar, ...
    'ngrid',200,@(x) isnumericscalar(x) && x >= 1, ...
    'rho','estimate', ...
    @(x) any(strcmpi(x,{'auto','estimate','negative','positive'})) ...
    || (isnumericscalar(x) && x > -1 && x < 1), ...
    'timetrend',false,@islogicalscalar, ...
    };

def.convertdaily = [convert,{ ...
    'ignorenan',true,@islogical, ...
    'method',@mean,@(x) isa(x,'function_handle') || isequal(x,'first') || isequal(x,'last'), ...
    'select',Inf,@(x) isnumeric(x), ...
    }];

def.convertaggregate = [convert,{ ...
    'ignorenan',false,@islogical, ...
    'method',@mean,@(x) isa(x,'function_handle') || isequal(x,'first') || isequal(x,'last'), ...
    'select',Inf,@(x) isnumeric(x), ...
    }];

def.convertinterp = [convert,{ ...
    'ignorenan',false,@islogical, ...
    'method','cubic',@(x) ischar(x), ...
    'position','centre',@(x) ischar(x) && any(strncmpi(x,{'c','s','e'},1)), ...
    }];

def.cumsumk = { ...
    'log',false,@islogicalscalar, ...
    };

def.errorbar = { ...
    'relative',true,@islogicalscalar, ...
    };

def.expsmooth = { ...
    'init',NaN,@isnumeric, ...
    'log',false,@islogicalscalar, ...
};

def.fft = { ...
    'full',false,@islogicalscalar, ...
    };

def.filter = { ...
    'change',[],@(x) isempty(x) || istseries(x), ...
    'drift',0,@(x) isnumeric(x) && length(x) == 1, ...
    'gap',[],@(x) isempty(x) || istseries(x), ...
    'growth',[],@(x) isempty(x) || istseries(x), ...
    'lambda',[],@(x) isempty(x) || isnumericscalar(x) || (ischar(x) && strcmpi(x,'auto')), ...
    'level',[],@(x) isempty(x) || istseries(x), ...
    'log',false,@islogical, ...
    'swap',false,@islogical, ...
    'forecast',[],@(x) isnumeric(x) && length(x) <= 1, ...
    };

def.mygraph = { ...
    dates{:}, ...
    'dateposition','c',@(x) ischar(x) && ~isempty(x) && any(x(1) == 'sec'), ...
    'function',[],@(x) isempty(x) || isa(x,'function_handle'), ...
    'tight',false,@islogicalscalar, ...
    };

def.interp = { ...
    'method','cubic',@ischar, ...
    };

def.moving = { ...
    'window',Inf,@isnumeric, ...
    'function',@mean,@(x) isa(x,'function_handle'), ...
    };

def.barcon = {
    'barwidth',0.8,@isnumericscalar, ...
    'colormap',[],@isnumeric, ...
    'evenlyspread',true,@islogicalscalar, ...
    'ordering','preserve',@(x) isanychari(x,{'descend','ascend','preserve'}) ...
    || isnumeric(x), ...
    };

def.normalise = { ...
    'mode','mult',@(x) any(strncmpi(x,{'add','mult'},3)), ...
    };

def.plotcmp = { ...
    'diffcolor',[1,0.75,0.75],@(x) isnumeric(x) && length(x) == 3 && all(x >= 0) && all(x <= 1), ...
    'rhsplotfunc',[],@(x) isempty(x) || isanychari(char(x),{'bar','area'}), ...
    'diffplotfunc',@bar,@(x) isanychari(char(x),{'bar','area'}), ...
    };

def.plotyy = { ...
    def.mygraph{:}, ...
    'coincident',false,@islogicalscalar, ...
    'highlight',[],@isnumeric, ...
    'lhsplotfunc',@plot,@(x) ischar(x) || isa(x,'function_handle'), ...
    'rhsplotfunc',@plot,@(x) ischar(x) || isa(x,'function_handle'), ...
    'lhstight',false,@islogicalscalar, ...
    'rhstight',false,@islogicalscalar, ...
    };

def.regress = {...
    'constant',false,@islogical, ...
    'weighting',[],@(x) (isnumeric(x) && isempty(x)) || istseries(x),...
    };

def.spy = { ...
    def.mygraph{:}, ...
    'names,name',{},@iscellstr, ...
    'test',@(x) ~isnan(x),@(x) isa(x,'function_handle'), ...    
    };

def.trend = { ...
    'break',[],@isnumeric, ...
    'connect',true,@islogicalscalar, ...
    'diff',false,@islogicalscalar, ...
    'log',false,@islogicalscalar, ...
    'season',false,@(x) isempty(x) || islogicalscalar(x) || isnumericscalar(x), ...
    };

def.windex = { ...
    'log',false,@islogical, ...
    'method','simple',@(x) ischar(x) && any(strcmpi(x,{'simple','divisia'})), ...
    };

def.x12 = { ...
    'arima',[], @(x) isempty(x) || islogicalscalar(x) ...
    || (isnumeric(x) && length(x) <= 2 && all(x >= 0) && all(x == round(x))), ...
    'backcast,backcasts',0,@(x) isnumericscalar(x), ...
    'cleanup,deletetempfiles,deletetempfile,deletex12file,deletex12file,delete',true,@islogicalscalar, ...
    'dummy',[],@(x) isempty(x) || isa(x,'tseries'), ...
    'dummytype','holiday',@(x) ischar(x) && any(strcmpi(x,{'holiday','td','ao'})), ...
    'display',false,@islogicalscalar, ...
    'forecast,forecasts',0,@(x) isnumericscalar(x), ...
    'log',false,@islogicalscalar, ...
    'maxiter',1500,@(x) isnumericscalar(x) && x > 0 && x == round(x), ...
    'maxorder',[2,1],@(x) isnumeric(x) && length(x) == 2 ...
    && any(x(1) == [1,2,3,4]) && any(x(2) == [1,2]), ...
    'mode','auto',@(x) (isnumeric(x) && any(x == -1 : 3)) || any(strcmp(x,{'add','a','mult','m','auto','sign','pseudo','pseudoadd','p','log','logadd','l'})), ...
    'output','d11',@(x) ischar(x) || iscellstr(x), ...
    'saveas','',@ischar, ...
    'specfile','default',@(x) ischar(x) || isinf(x), ...
    'tdays,tday',false,@islogicalscalar, ...
    'tolerance',1e-5,@(x) isnumericscalar(x) && x > 0, ...
    };

end