function def = qreport()
% qreport  [Not a public function] Default options for quick-report functions.
%
% Backend IRIS function
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

def = struct();

def.qplot = {...
    'addclick',true,@islogicalscalar, ...
    'clear',[],@isnumeric, ...
    'drawnow',false,@islogical, ...
    'grid',true,@islogicalscalar, ...
    'highlight',[],@(x) isnumeric(x) ...
    || (iscell(x) && all(cellfun(@isnumeric,x))), ...
    'mark',{},@(x) iscell(x) || ischar(x), ...
    'prefix','P%g_',@ischar, ...
    'round',Inf,@(x) isnumericscalar(x) && x >= 0 && round(x) == x, ...
    'sstate',struct(),@(x) isempty(x) || isstruct(x) || isa(x,'model'), ...
    'style',struct(),@(x) isempty(x) || isstruct(x) || (iscellstr(x) && length(x) == 1), ...
    'tight',false,@islogicalscalar, ...
    'vline',[],@(x) isempty(x) || isnumeric(x), ...
    'zeroline',false,@islogicalscalar, ...
    };

def.qreport = {...
    'addclick',true,@islogicalscalar, ...
    'clear',[],@isnumeric, ...
    'dbsave',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'drawnow',false,@islogical, ...
    'grid',true,@islogicalscalar, ...
    'highlight',[],@(x) isnumeric(x) ...
    || (iscell(x) && all(cellfun(@isnumeric,x))), ...
    'interpreter','none',@(x) any(strcmpi(x,{'none','latex'})), ...
    'mark',{},@iscellstr, ...
    'overflow',false,@islogicalscalar, ...
    'pagenumber,pagenumbers',false,@islogicalscalar, ...    
    'plotfunc',@plot,@(x) (isa(x,'function_handle') || ischar(x)) ...
    && any(strcmpi(char(x),{'plot','bar','stem','hist','plotpred','errorbar','plotcmp'})), ...
    'prefix','P%g_',@ischar, ...
    'round',Inf,@(x) isnumericscalar(x) && x >= 0 && round(x) == x, ...
    'saveas','',@ischar, ...
    'sstate',struct(),@(x) isempty(x) || isstruct(x) || isa(x,'model'), ...
    'style',struct(),@(x) isempty(x) || isstruct(x) || (iscellstr(x) && length(x) == 1), ...
    'subplot','auto',@(x) strcmpi(x,'auto') ...
    || (isnumeric(x) && length(x) == 2 && all(~isnan(x) & x > 0 & x == round(x))), ...
    'tight',false,@islogicalscalar, ...
    'title,titles',{},@(x) isempty(x) || iscellstr(x) || isa(x,'function_handle'), ...
    'transform',[],@(x) isempty(x) || isa(x,'function_handle'), ...
    'vline',[],@(x) isempty(x) || isnumeric(x), ...
    'xlabel','',@(x) ischar(x) || iscellstr(x), ...
    'ylabel','',@(x) ischar(x) || iscellstr(x), ...
    'zeroline',false,@islogicalscalar, ...
    };

def.qstyle = { ...
    'cascade',true,@islogicalscalar, ...
    'offset',0,@isnumericscalar, ...
    'warning',true,@islogicalscalar, ...
    };

end
