function def = poster()
% poster  [Not a public function] Default options for poster class.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

def = struct();

def.arwm = { ...
    'burnin',0.10,@(x) isnumericscalar(x) ...
    && ((x >= 0 && x < 1) || (x > 1 && x == round(x))), ...
    'esttime',false,@islogicalscalar, ...
    'initscale',1/3,@isnumericscalar, ...
    'gamma',0.8,@(x) isnumericscalar(x) ....
    && ( (x > 0.5 && x <= 1) || isnan(x) || isinf(x) ), ...
    'adaptscale',1,@(x) isnumericscalar(x) && x >= 0, ...
    'adaptproposalcov',0,@(x) isnumericscalar(x) && x >= 0, ...
    'progress',false,@islogicalscalar, ...
    'saveevery',Inf,@(x) isnumericscalar(x) && x > 0 && x == round(x), ...
    'saveas','',@ischar, ...
    'targetar',0.234,@(x) isnumericscalar(x) && x > 0 && x <= 0.5, ...
    };

def.statistics = { ...
    'esttime',false,@islogicalscalar, ...
    'hpdicover',90,@(x) isnumericscalar(x) && x >= 0 && x <= 100, ...
    'histbins,histbin',50,@(x) isnumericscalar(x) && x > 0 && x == round(x), ...
    'mddgrid',0.1:0.1:0.9,@(x) isnumeric(x) && all(x(:) > 0 & x(:) < 1), ...
    'output','mdd,chain,mean,std,hpdi',@(x) ischar(x) || iscellstr(x), ...
    'progress',false,@islogicalscalar, ...
    'prctile',[10,90],@(x) isnumeric(x) && all(x >= 0 & x <= 100), ...
    };

def.testpar = { ...
    };

end