function def = SVAR()
% SVAR  [Not a public function] Default options for SVAR class functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

def = struct();

outputformat = { ...
    'output','auto',@(x) any(strcmpi(x,{'auto','dbase','tseries','array'})), ...
    };

def.sort = [...
    outputformat, { ...
    'progress',false,@islogicalscalar, ...
    }];

def.sprintf = { ...
    'constant',true,@islogicalscalar, ...
    'decimal',[], @(x) isempty(x) || isnumericscalar(x), ...
    'declare',false,@islogicalscalar, ...
    'enames,ename',[],@(x) isempty(x) || iscellstr(x) || isfunc(x), ...
    'format','%+.16e',@ischar, ...
    'hardparameters,hardparameter',true,@islogicalscalar, ...
    'tolerance',getrealsmall(),@isnumericscalar, ...
    'ynames,yname',[],@(x) isempty(x) || iscellstr(x), ...
    };

def.srf = { ...
    'presample',false,@islogicalscalar, ...
    'select',Inf,@(x) isequal(x,Inf) || islogical(x) || isnumeric(x) || ischar(x) || iscellstr(x), ...
    };

def.SVAR = [ ...
    outputformat, { ...
    'maxiter',0,@(x) isnumericscalar(x) && x >= 0, ...
    'method','chol',@(x) any(strcmpi(x,{'chol','qr','svd','householder'})), ...
    'ndraw',0,@(x) isnumericscalar(x) && x >= 0, ...
    'ordering',[],@isnumeric, ...
    'progress',false,@islogicalscalar, ...
    'reorderresiduals,reorderresidual',true,@islogical, ...
    'rank',Inf,@isnumericscalar, ...
    'std',1,@isnumericscalar, ...
    'test','',@ischar, ...
    }];

end