function TT = title(varargin)
% title  [Not a public function] Advanced graph titles and subtitles.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if all(ishghandle(varargin{1}))
    ax = varargin{1};
    varargin(1) = [];
else
    ax = gca();
end

TT = [];
if isempty(varargin)
    return
end

text = varargin{1};
varargin(1) = [];

%**************************************************************************

% Add title to the current subplot.
% * Double backslash, \\, is line breaks.
% * Double underscore, __, is subtitles.
match = regexp(strrep(text,'__',char(10)),'[^\n]+','match');

if isempty(match)
    tmptitle = '';
    tmpsubtitle = '';
elseif length(match) == 1
    tmptitle = strtrim(match{1});
    tmpsubtitle = '';
else
    tmptitle = strtrim(match{1});
    tmpsubtitle = strtrim(match{end});
end

tmptitle = strrep(tmptitle,'//',char(10));
tmptitle = strrep(tmptitle,'\\',char(10));
tmptitle = regexp(tmptitle,'[^\n]+','match');
tmptitle = tmptitle(:);

if ~isempty(tmpsubtitle)
    tmptitle{end+1} = ['\it{',tmpsubtitle,'}'];
end

if ~isempty(tmptitle)
    TT = title(ax,tmptitle,varargin{:});
end

end