function [h,hu] = ploteig(x,varargin)
% ploteig  Plot eigenvalues in complex plane.
%
% Syntax
% =======
%
%     [H,U] = grfun.ploteig(OBJ,...)
%     [H,U] = ploteig(OBJ,...)
%
% Input arguments
% ================
%
% * `OBJ` [ model | VAR | SVAR | FAVAR | numeric ] - Vector of complex
% numbers or an object to which the function `eig` can be applied.
%
% Output arguments
% =================
%
% * `H` [ numeric ] - Handle to the eigenvalue plot.
%
% * `U` [ numeric ] - Handle to a unit circle plot.
%
% Options
% ========
%
% * `'uCircle='` [ *`true`* | `false` ] - Draw a unit circle first.
%
% Any options valid for the `plot` function.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

[options,varargin] = passvalopt('grfun.ploteig',varargin{:});

plotspec = [ ...
   {'marker','x','markersize',8,'linestyle','none','linewidth',1.5}, ...
   varargin{:}, ...
];

%**************************************************************************

if ~isnumeric(x) || ~isvector(x)
   x = eig(x);
end

h = plot(real(x),imag(x),plotspec{:});

hu = [];
if options.ucircle
   nextplot = get(gca,'nextplot');
   set(gca,'nextplot','add');
   hu = ucircle();
   set(gca,'nextplot',nextplot);
   grfun.excludefromlegend(hu);
end

end
