function ls = listener(leader,follower,name,varargin)

% Choose the appropriate listener function.
if ~feature('HGUsingMATLABClasses')
    listenerFcn = @handle.listener;
    postSetStr = 'PropertyPostSet';
else
    listenerFcn = @event.proplistener;
    postSetStr = 'PostSet';
end

% Convert graphics handle to graphics object.
leaderobj = handle(leader);

switch name
    
    case 'highlight'
        ls = listenerFcn(leaderobj, ...
            findprop(leaderobj,'YLim'),...
            postSetStr, ...
            @(obj,evd)(xxhighlight(obj,evd,leader,follower)));

    case 'vline'
        ls = listenerFcn(leaderobj, ...
            findprop(leaderobj,'YLim'),...
            postSetStr, ...
            @(obj,evd)(xxvline(obj,evd,leader,follower)));

    case 'zeroline'
        ls = listenerFcn(leaderobj, ...
            findprop(leaderobj,'XLim'),...
            postSetStr, ...
            @(obj,evd)(xxzeroline(obj,evd,leader,follower)));

    case 'caption'
        ls = listenerFcn(leaderobj, ...
            findprop(leaderobj,'YLim'),...
            postSetStr, ...
            @(obj,evd)(xxcaption(obj,evd,leader,follower,varargin{1})));

end

% Make sure the listener object persists.
setappdata(follower,[name,'Listener'],ls);

end

% Subfunctions.

%**************************************************************************
function xxhighlight(obj,evd,ax,pt) %#ok<INUSL>
    y = get(ax,'yLim');
    set(pt,'yData',[y(1),y(1),y(2),y(2),y(1)]);
end
% highlight_().

%**************************************************************************
function xxvline(obj,evd,ax,ln) %#ok<INUSL>
    y = get(ax,'yLim');
    set(ln,'yData',y);
end
% vline_().

%**************************************************************************
function xxzeroline(obj,evd,ax,ln) %#ok<INUSL>
    x = get(ax,'xLim');
    set(ln,'xData',x);
end
% zeroline_().

%**************************************************************************
function xxcaption(obj,evd,ax,cp,k) %#ok<INUSL>
    ylim = get(ax,'yLim');
    yspan = ylim(end) - ylim(1);
    pos = get(cp,'position');
    pos(2) = ylim(1)+k*yspan;
    set(cp,'position',pos);
end
% caption_().
