clear;
clc;

[num] = xlsread('Greece Misdiagnosis.xlsx','Sheet1');

year = num(:,1);
stage1 = num(:,2);
stage2 = num(:,3);
stage3 = num(:,4);
stage4a = num(:,5);
stage4b = num(:,6);
stage4c = num(:,7);

%%
% Create figure
figure;
% Create multiple lines using matrix input to plot
plot(year,stage1,'LineWidth',3,'Color',[0.2 0.2 0.2]);
hold on;
plot(year,stage2,'LineWidth',3,'Color',[0.4 0.4 0.4]);
plot(year,stage3,'LineWidth',3,'Color',[0.6 0.6 0.6]);
plot(year,stage4a,'LineWidth',3,'Color',[0.6 0.6 0.6]);
plot(year,stage4b,'LineWidth',3,'Color',[0.8 0.8 0.8]);
scatter(year,stage4c,'MarkerFaceColor',[0.8 0.8 0.8],...
    'MarkerEdgeColor',[0.8 0.8 0.8],...
    'LineWidth',3);
plot([2017 2022],[200 170],'LineWidth',3,'Color',[0.8 0.8 0.8],'LineStyle','--');
ylim([90 210]);
grid on;
text(2010,115,{'Stage 1','August 2009'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,135,{'Stage 2','May 2010'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2011.5,185,{'Stage 3','2011-14'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,160,{'(i) July 2011'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2013.5,170,'(ii) June 2014)','EdgeColor','k','BackgroundColor','w')
text(2016.5,185,{'Stage 4','2014-15'},'EdgeColor','k','BackgroundColor','w');
text(2017.5,160,'(i) June 2015)','EdgeColor','k','BackgroundColor','w')
text(2019,180,'(ii) July 2015)','EdgeColor','k','BackgroundColor','w')
ylabel('Debt/GDP (%)');
xlabel('Year');


%%
% STEP BY STEP figure - 1
figure;
% Create multiple lines using matrix input to plot
plot(year,stage1,'LineWidth',3,'Color',[0.2 0.2 0.2]);
hold on;
ylim([90 210]);
xlim([2008 2024])
grid on;
text(2010,115,{'Stage 1','August 2009'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
ylabel('Debt/GDP (%)');
xlabel('Year');

% STEP BY STEP figure - 2
figure;
% Create multiple lines using matrix input to plot
plot(year,stage1,'LineWidth',3,'Color',[0.2 0.2 0.2]);
hold on;
plot(year,stage2,'LineWidth',3,'Color',[0.4 0.4 0.4]);
ylim([90 210]);
xlim([2008 2024])
grid on;
text(2010,115,{'Stage 1','August 2009'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,135,{'Stage 2','May 2010'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
ylabel('Debt/GDP (%)');
xlabel('Year');

% STEP BY STEP figure - 3
figure;
% Create multiple lines using matrix input to plot
plot(year,stage1,'LineWidth',3,'Color',[0.2 0.2 0.2]);
hold on;
plot(year,stage2,'LineWidth',3,'Color',[0.4 0.4 0.4]);
plot(year,stage3,'LineWidth',3,'Color',[0.6 0.6 0.6]);
plot(year,stage4a,'LineWidth',3,'Color',[0.6 0.6 0.6]);
ylim([90 210]);
xlim([2008 2024])
grid on;
text(2010,115,{'Stage 1','August 2009'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,135,{'Stage 2','May 2010'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2011.5,185,{'Stage 3','2011-14'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,160,{'(i) July 2011'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2013.5,170,'(ii) June 2014)','EdgeColor','k','BackgroundColor','w')
ylabel('Debt/GDP (%)');
xlabel('Year');

% STEP BY STEP figure - 4
figure;
% Create multiple lines using matrix input to plot
plot(year,stage1,'LineWidth',3,'Color',[0.2 0.2 0.2]);
hold on;
plot(year,stage2,'LineWidth',3,'Color',[0.4 0.4 0.4]);
plot(year,stage3,'LineWidth',3,'Color',[0.6 0.6 0.6]);
plot(year,stage4a,'LineWidth',3,'Color',[0.6 0.6 0.6]);
plot(year,stage4b,'LineWidth',3,'Color',[0.8 0.8 0.8]);
scatter(year,stage4c,'MarkerFaceColor',[0.8 0.8 0.8],...
    'MarkerEdgeColor',[0.8 0.8 0.8],...
    'LineWidth',3);
plot([2017 2022],[200 170],'LineWidth',3,'Color',[0.8 0.8 0.8],'LineStyle','--');
ylim([90 210]);
grid on;
text(2010,115,{'Stage 1','August 2009'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,135,{'Stage 2','May 2010'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2011.5,185,{'Stage 3','2011-14'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2010,160,{'(i) July 2011'},'EdgeColor',[0 0 0],'BackgroundColor',[1 1 1]);
text(2013.5,170,'(ii) June 2014)','EdgeColor','k','BackgroundColor','w')
text(2016.5,185,{'Stage 4','2014-15'},'EdgeColor','k','BackgroundColor','w');
text(2017.5,160,'(i) June 2015)','EdgeColor','k','BackgroundColor','w')
text(2019,180,'(ii) July 2015)','EdgeColor','k','BackgroundColor','w')
ylabel('Debt/GDP (%)');
xlabel('Year');

