

	clear
	set more off
	version 12
	
	import excel using "Greece Debt.xls", sheet("Stata") first
	
	rename Amount amount
	rename Debt debt
	rename Date date

	gen month = mofd(date)
	format month %tm
	
	gen quarter = qofd(date)
	format quarter %tq
	
	gen year = yofd(date)

	* Gen present value
	
	* IMF discount rate
	local today = td(27jul2015)
	local discount = 0.05
		
	gen horizon = date - `today'

	* Risk free discount rate
	* (Data points from Bloomberg)
	gen discount_rf = .
	
	gen m3 = 	-0.00309
	gen m6 = 	-0.00248
	gen y1 = 	-0.00258
	gen y2 = 	-0.00236
	gen y3 = 	-0.00182
	gen y4 = 	-0.00088
	gen y5 = 	-0.00032
	gen y7 =	 0.00288
	gen y8 =	 0.00414
	gen y9 =	 0.00531
	gen y10 =	 0.00635
	gen y15 =	 0.00997
	gen y20 =	 0.01223
	gen y25 =	 0.01313
	gen y30 =	 0.01361
	
	qui replace discount_rf = m3 if horizon <=90
	qui replace discount_rf = m3 + (m6-m3)*(horizon-90)/90 if horizon > 90 & horizon<=180
	qui replace discount_rf = m6 + (y1-m6)*(horizon-180)/180 if horizon > 180 & horizon<=365
	
	local i = 1
			while `i' <= 4 {
				local j = `i'+1
				qui replace discount_rf = y`i' + (y`j'-y`i')*(horizon-365*`i')/365 if horizon>365*`i' & horizon<=365*(`i'+1)
				local i = `i'+1
			}
	
	qui replace discount_rf = y5 + (y7-y5)*(horizon-365*5)/(365*2) if horizon>365*5 & horizon<=365*7
			
	local i = 7
			while `i' <= 9 {
				local j = `i'+1
				qui replace discount_rf = y`i' + (y`j'-y`i')*(horizon-365*`i')/365 if horizon>365*`i' & horizon<=365*(`i'+1)
				local i = `i'+1
			}		
			
	qui replace discount_rf = y9  + (y10-y9)*(horizon-365*9)/365 if horizon>365*9 & horizon<=365*10
	qui replace discount_rf = y10 + (y15-y10)*(horizon-365*10)/(365*5) if horizon>365*10 & horizon<=365*15
	qui replace discount_rf = y15 + (y20-y15)*(horizon-365*15)/(365*5) if horizon>365*15 & horizon<=365*20
	qui replace discount_rf = y20 + (y25-y20)*(horizon-365*20)/(365*5) if horizon>365*20 & horizon<=365*25
	qui replace discount_rf = y25 + (y30-y25)*(horizon-365*25)/(365*5) if horizon>365*25 & horizon<=365*30	
	qui replace discount_rf = y30 if horizon > 365*30
	
	drop m3-y30
	
	* Market discount rate
	* (Data points from Bloomberg)	
	gen discount_gr = .
	
	gen m3 = 	0.03197
	gen m6 = 	0.03695
	gen y1 = 	0.06572
	gen y2 = 	0.12093
	gen y3 = 	0.15399
	gen y4 = 	0.16071
	gen y5 = 	0.15419
	gen y7 =	0.13809
	gen y8 =	0.13096
	gen y9 =	0.12127
	gen y10 =	0.11473
	gen y15 =	0.10288
	gen y20 =	0.09734
	gen y25 =	0.09182
	gen y30 =	0.09057

	qui replace discount_gr = m3 if horizon <=90
	qui replace discount_gr = m3 + (m6-m3)*(horizon-90)/90 if horizon > 90 & horizon<=180
	qui replace discount_gr = m6 + (y1-m6)*(horizon-180)/180 if horizon > 180 & horizon<=365
	
	local i = 1
			while `i' <= 4 {
				local j = `i'+1
				qui replace discount_gr = y`i' + (y`j'-y`i')*(horizon-365*`i')/365 if horizon>365*`i' & horizon<=365*(`i'+1)
				local i = `i'+1
			}
			
	qui replace discount_gr = y5 + (y7-y5)*(horizon-365*5)/(365*2) if horizon>365*5 & horizon<=365*7
			
	local i = 7
			while `i' <= 9 {
				local j = `i'+1
				qui replace discount_gr = y`i' + (y`j'-y`i')*(horizon-365*`i')/365 if horizon>365*`i' & horizon<=365*(`i'+1)
				local i = `i'+1
			}		
			
	qui replace discount_gr = y9  + (y10-y9)*(horizon-365*9)/365 if horizon>365*9 & horizon<=365*10
	qui replace discount_gr = y10 + (y15-y10)*(horizon-365*10)/(365*5) if horizon>365*10 & horizon<=365*15
	qui replace discount_gr = y15 + (y20-y15)*(horizon-365*15)/(365*5) if horizon>365*15 & horizon<=365*20
	qui replace discount_gr = y20 + (y25-y20)*(horizon-365*20)/(365*5) if horizon>365*20 & horizon<=365*25
	qui replace discount_gr = y25 + (y30-y25)*(horizon-365*25)/(365*5) if horizon>365*25 & horizon<=365*30	
	qui replace discount_gr = y30 if horizon > 365*30
	
	drop m3-y30
	
	* Relabel creditor variables			
	gen creditor = debt
	replace creditor = "IMF" if debt == "IMF (Interest)"
	replace creditor = "IMF" if debt == "IMF (Principal)"
	replace creditor = "ESCB" if debt == "ECB & NCB (Interest)"
	replace creditor = "ESCB" if debt == "ECB & NCB (Principal)"
	replace creditor = "Holdouts" if debt == "Holdouts (Principal)"	
	replace creditor = "Holdouts" if debt == "Holdouts (Interest)"
	replace creditor = "PSI Bonds" if debt == "PSI Bonds (Interest)"
	replace creditor = "PSI Bonds" if debt == "PSI Bonds (Principal)"	
	replace creditor = "Euro gov'ts" if debt == "Eurozone gov'ts (Interest)"
	replace creditor = "Euro gov'ts" if debt == "Eurozone gov'ts (Principal)"
	replace creditor = "EFSF" if debt == "EFSF (Interest)"
	replace creditor = "EFSF" if debt == "EFSF (Principal)"
	
	gen principal = regexm(debt,"Principal")
	replace principal = 1 if debt == "T-Bills"
	replace principal = 1 if debt == "Bank of Greece"
	
	* IMF discount rate
	local today = td(27jul2015)
	local discount = 0.05
	
	gen nominal_value = amount if principal == 1
	gen interest_value = amount if principal == 0
	gen present_value = amount / exp(`discount'*((date-`today')/365))
	gen present_value_rf = amount / exp(discount_rf*((date-`today')/365))
	gen present_value_gr = amount / exp(discount_gr*((date-`today')/365))
	
	* For paper
	tabstat amount nominal_value interest_value present_value, by(creditor) s(sum)	
	
	* For online appendix
	tabstat nominal_value present_value present_value_rf present_value_gr, by(creditor) s(sum)	
		
	* Graph repayment profile
	
	collapse (sum) amount, by(year creditor)
	
	replace creditor = "TBills" if creditor == "T-Bills"
	replace creditor = "BankofGreece" if creditor == "Bank of Greece"
	replace creditor = "EurozoneGovts" if creditor == "Euro gov'ts"
	replace creditor = "PSIBonds" if creditor == "PSI Bonds"
	
	reshape wide amount, i(year) j(creditor) string
	
	tsset year
	tsfill
	
	order amountTBills amountPSIBonds amountHoldouts amountESCB amountIMF amountEFSF amountEurozoneGovts amountBankofGreece
	
	graph bar amount*, over(year, label(angle(90))) stack scheme(s1color) ytitle("Bn EUR") ylabel(,angle(0) nogrid) ///
			legend(label(1 "T-Bills") label(2 "PSI Bonds") label(3 "Holdouts") label(4 "ESCB") label(5 "IMF") label(6 "EFSF") label(7 "GLF") label(8 "Bank of Greece") position(2) ring(0)) ///
			plotregion(m(zero)) graphregion(color(white))	
