* Variance Decomposition for Baseline ECM with lambda series restricted
* to 4-degree polynomial, on PSID data.
* To compute the variance decomposition, uncomment the desired set of 
* parameter estimates (and make sure all other parameter estimates 
* are commented out), and select (by commenting out/uncommenting)
* the corresponding weights file (which does the appropriate 
* weighting by the empirical age distribution of the corresponding
* sample.

clear all

local path  ./weights_PSID                /* set path for weights data */
       
local weights weights_psid_labinc.dta     /* Male Earnings */
*local weights weights_psid_faminc.dta     /* Family Income */


**********************************************************************
    /* Estimates for labinc (LabIncHD) (with weights) */

     local s2a = 0.12874680
     local psi = 0.95549180
     local s2n = 0.01724300
     local s2e = 0.11647560
     local theta1 = 0.08843410
     local theta2 = 0.08155580

     local pi1987 = 1.0
     local pi1988 = 0.97491730
     local pi1989 = 0.80733200
     local pi1990 = 0.94623580
     local pi1991 = 0.87601590
     local pi1992 = 1.01743000
     local pi1993 = 1.09536500
     local pi1994 = 0.93618770
     local pi1995 = 0.81810040
     local pi1996 = 0.77830100
     local pi1998 = 0.89462370
     local pi2000 = 1.01717700
     local pi2002 = 1.26047100
     local pi2004 = 1.15690400
     local pi2006 = 0.95475580
     local pi2008 = 1.17699200

     local b1_lam =  0.02907020
     local b2_lam = -0.00666200
     local b3_lam =  0.00052120
     local b4_lam = -0.00001190

**********************************************************************
    /* Estimates for faminc (FamInc) (with weights) */

*     local s2a = 0.15274090
*     local psi = 0.98998200
*     local s2n = 0.00636170
*     local s2e = 0.14982960
*     local theta1 = 0.30961910
*     local theta2 = 0.26465960

*     local pi1987 = 1.0
*     local pi1988 = 0.93985460
*     local pi1989 = 0.94986400
*     local pi1990 = 0.88559620
*     local pi1991 = 0.94865760
*     local pi1992 = 1.02446600
*     local pi1993 = 1.23735700
*     local pi1994 = 1.13138700
*     local pi1995 = 1.09021000
*     local pi1996 = 1.06121700
*     local pi1998 = 1.04103400
*     local pi2000 = 1.15284000
*     local pi2002 = 1.14887900
*     local pi2004 = 1.23004000
*     local pi2006 = 1.13862900
*     local pi2008 = 1.16635000

*     local b1_lam =  0.04426240
*     local b2_lam = -0.00699730
*     local b3_lam =  0.00041440
*     local b4_lam = -0.00000776

**********************************************************************

* Set missing values of pi

     local pi1997 = .5*(`pi1996' + `pi1998')
     local pi1999 = .5*(`pi1998' + `pi2000')
     local pi2001 = .5*(`pi2000' + `pi2002')
     local pi2003 = .5*(`pi2002' + `pi2004')
     local pi2005 = .5*(`pi2004' + `pi2006')
     local pi2007 = .5*(`pi2006' + `pi2008')
     local pi2009 = `pi2008'

* Set lambda

    local lam1987 =  1.0       
    local lam1988 = `lam1987' +  (1.0)*(`b1_lam') +  (1.0^2)*(`b2_lam') +  (1.0^3)*(`b3_lam') +  (1.0^4)*(`b4_lam')
    local lam1989 = `lam1987' +  (2.0)*(`b1_lam') +  (2.0^2)*(`b2_lam') +  (2.0^3)*(`b3_lam') +  (2.0^4)*(`b4_lam')
    local lam1990 = `lam1987' +  (3.0)*(`b1_lam') +  (3.0^2)*(`b2_lam') +  (3.0^3)*(`b3_lam') +  (3.0^4)*(`b4_lam')
    local lam1991 = `lam1987' +  (4.0)*(`b1_lam') +  (4.0^2)*(`b2_lam') +  (4.0^3)*(`b3_lam') +  (4.0^4)*(`b4_lam')
    local lam1992 = `lam1987' +  (5.0)*(`b1_lam') +  (5.0^2)*(`b2_lam') +  (5.0^3)*(`b3_lam') +  (5.0^4)*(`b4_lam')
    local lam1993 = `lam1987' +  (6.0)*(`b1_lam') +  (6.0^2)*(`b2_lam') +  (6.0^3)*(`b3_lam') +  (6.0^4)*(`b4_lam')
    local lam1994 = `lam1987' +  (7.0)*(`b1_lam') +  (7.0^2)*(`b2_lam') +  (7.0^3)*(`b3_lam') +  (7.0^4)*(`b4_lam')
    local lam1995 = `lam1987' +  (8.0)*(`b1_lam') +  (8.0^2)*(`b2_lam') +  (8.0^3)*(`b3_lam') +  (8.0^4)*(`b4_lam')
    local lam1996 = `lam1987' +  (9.0)*(`b1_lam') +  (9.0^2)*(`b2_lam') +  (9.0^3)*(`b3_lam') +  (9.0^4)*(`b4_lam')
    local lam1997 = `lam1987' + (10.0)*(`b1_lam') + (10.0^2)*(`b2_lam') + (10.0^3)*(`b3_lam') +  (10.0^4)*(`b4_lam')
    local lam1998 = `lam1987' + (11.0)*(`b1_lam') + (11.0^2)*(`b2_lam') + (11.0^3)*(`b3_lam') +  (11.0^4)*(`b4_lam')
    local lam1999 = `lam1987' + (12.0)*(`b1_lam') + (12.0^2)*(`b2_lam') + (12.0^3)*(`b3_lam') +  (12.0^4)*(`b4_lam')
    local lam2000 = `lam1987' + (13.0)*(`b1_lam') + (13.0^2)*(`b2_lam') + (13.0^3)*(`b3_lam') +  (13.0^4)*(`b4_lam')
    local lam2001 = `lam1987' + (14.0)*(`b1_lam') + (14.0^2)*(`b2_lam') + (14.0^3)*(`b3_lam') +  (14.0^4)*(`b4_lam')
    local lam2002 = `lam1987' + (15.0)*(`b1_lam') + (15.0^2)*(`b2_lam') + (15.0^3)*(`b3_lam') +  (15.0^4)*(`b4_lam')
    local lam2003 = `lam1987' + (16.0)*(`b1_lam') + (16.0^2)*(`b2_lam') + (16.0^3)*(`b3_lam') +  (16.0^4)*(`b4_lam')
    local lam2004 = `lam1987' + (17.0)*(`b1_lam') + (17.0^2)*(`b2_lam') + (17.0^3)*(`b3_lam') +  (17.0^4)*(`b4_lam')
    local lam2005 = `lam1987' + (18.0)*(`b1_lam') + (18.0^2)*(`b2_lam') + (18.0^3)*(`b3_lam') +  (18.0^4)*(`b4_lam')
    local lam2006 = `lam1987' + (19.0)*(`b1_lam') + (19.0^2)*(`b2_lam') + (19.0^3)*(`b3_lam') +  (19.0^4)*(`b4_lam')
    local lam2007 = `lam1987' + (20.0)*(`b1_lam') + (20.0^2)*(`b2_lam') + (20.0^3)*(`b3_lam') +  (20.0^4)*(`b4_lam')
    local lam2008 = `lam1987' + (21.0)*(`b1_lam') + (21.0^2)*(`b2_lam') + (21.0^3)*(`b3_lam') +  (21.0^4)*(`b4_lam')
    local lam2009 = `lam1987' + (22.0)*(`b1_lam') + (22.0^2)*(`b2_lam') + (22.0^3)*(`b3_lam') +  (22.0^4)*(`b4_lam')

    * NOTE: Create scalars such as pi1990 with the same value as local macro `pi1990'
    * to access below by references such as pi`h' (where `h' is a macro: an index from a loop).

    scalar pi1987 = `pi1987'
    scalar pi1988 = `pi1988'
    scalar pi1989 = `pi1989'
    scalar pi1990 = `pi1990'
    scalar pi1991 = `pi1991'
    scalar pi1992 = `pi1992'
    scalar pi1993 = `pi1993'
    scalar pi1994 = `pi1994'
    scalar pi1995 = `pi1995'
    scalar pi1996 = `pi1996'
    scalar pi1997 = `pi1997'
    scalar pi1998 = `pi1998'
    scalar pi1999 = `pi1999'
    scalar pi2000 = `pi2000'
    scalar pi2001 = `pi2001'
    scalar pi2002 = `pi2002'
    scalar pi2003 = `pi2003'
    scalar pi2004 = `pi2004'
    scalar pi2005 = `pi2005'
    scalar pi2006 = `pi2006'
    scalar pi2007 = `pi2007'
    scalar pi2008 = `pi2008'
    scalar pi2009 = `pi2009'

    scalar lam1987 = `lam1987'
    scalar lam1988 = `lam1988'
    scalar lam1989 = `lam1989'
    scalar lam1990 = `lam1990'
    scalar lam1991 = `lam1991'
    scalar lam1992 = `lam1992'
    scalar lam1993 = `lam1993'
    scalar lam1994 = `lam1994'
    scalar lam1995 = `lam1995'
    scalar lam1996 = `lam1996'
    scalar lam1997 = `lam1997'
    scalar lam1998 = `lam1998'
    scalar lam1999 = `lam1999'
    scalar lam2000 = `lam2000'
    scalar lam2001 = `lam2001'
    scalar lam2002 = `lam2002'
    scalar lam2003 = `lam2003'
    scalar lam2004 = `lam2004'
    scalar lam2005 = `lam2005'
    scalar lam2006 = `lam2006'
    scalar lam2007 = `lam2007'
    scalar lam2008 = `lam2008'
    scalar lam2009 = `lam2009'

    * Specify piXXXX for a few years before 1987.
    * Create the piXXXX both as local macro and as scalar.

    local pi1981 = 1.0
    local pi1982 = 1.0
    local pi1983 = 1.0
    local pi1984 = 1.0
    local pi1985 = 1.0
    local pi1986 = 1.0

    scalar pi1981 = `pi1981'
    scalar pi1982 = `pi1982'
    scalar pi1983 = `pi1983'
    scalar pi1984 = `pi1984'
    scalar pi1985 = `pi1985'
    scalar pi1986 = `pi1986'


*** Loop to assign values to scalar varp_`yr'_`age'

  forvalues cohort = 1952(1)2009 {

    forvalues age = 1(1)36 {

      local yr    = `cohort' + `age' - 1
      local yrm1  = `yr' - 1
      local yrm2  = `yr' - 2
      local agem1 = `age' - 1

      if `yr' <= 2009 {

        if `age' == 1 {
           scalar varp_`yr'_`age' = (`s2n')
        }

        if `age' >= 2 {
           scalar varp_`yr'_`age' = ((`psi')^2)*varp_`yrm1'_`agem1' + (`s2n')
        }

      }

    }

  }



***** Assign values to dependent variable:


    /* Initialize output variables */

    set obs 10000

    gen year = 0

    gen lead = 0

    gen PE = 0

    gen ycov = 0

    gen perm = 0

    gen tran = 0

    /* Initialize counter for output */

    local n = 1


***** Assign values to dependent variable:

    forvalues t = 1987(1)2009 {
      local tm1 = `t'-1
      local tm2 = `t'-2
      local maxK = 2009-`t'
      forvalues h = 1(1)36 {
        forvalues k = 0(1)`maxK' {
          local tpk = `t'+`k'

          /* Output result to observation n */

          qui replace ycov = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`k'))*varp_`t'_`h' ) + (`k'==0)*(`s2e')*( ((pi`t')^2) + (`h'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`h'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`k'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`h'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`k'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if _n == `n'

          qui replace perm = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`k'))*varp_`t'_`h' )  if _n == `n'

          qui replace tran = (`k'==0)*(`s2e')*( ((pi`t')^2) + (`h'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`h'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`k'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`h'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`k'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if _n == `n'

          qui replace year = `t' if _n == `n'
          qui replace lead = `k' if _n == `n'
          qui replace PE   = `h' if _n == `n'

          /* Increment counter for output */
          local n = `n' + 1

        }
      }
    }


    foreach h of numlist 1 5 15 20 25 35 {
        list PE year ycov perm tran  if (lead==0 & PE==`h'), clean noobs
    }

    *******************************************************************
    * Compute permanent-transitory variance decomposition for
    * all values of age (PE), weighting by the relative age weights for
    * each calendar year.  Make sure to read the appropriate weights
    * file (see below, merge statement).
    *******************************************************************

    keep if year!=0

    keep if lead==0

    * merge age dist'n weights

    sort year PE


    * For PSID:

    merge year PE using  `path'/`weights'

    keep if _merge==3
    drop _merge

    gen ycov_w = ycov*weight   /* multiply by weights to compute weighted means */
    gen perm_w = perm*weight   /* note: weights add to 1 across PE for each year */
    gen tran_w = tran*weight

    *preserve

    collapse (sum) ycov_w perm_w tran_w, by(year)   /* computes weighted average */

    disp "Persistent-Transitory Variance Decomposition: Total, Persistent, Transitory "
    list, clean noobs

    *restore


    log close
