clear all

* select variable:

 local var labinc
*local var faminc


use  ../../../Data/CovsData_PSID_`var'_CAL.dta, clear


keep if jvar==0                 /* keep variances only */

keep yrvar hvar wgtvar
rename yrvar year
rename hvar age
rename wgtvar wgt


* Note: In order to use weights in VarDec programs, the weights need to be defined 
* for all years 1987-2009. So, first need to fill in the missing years (set weights to 
* midpoint of adjacent years, and set 2009=2008).
*

reshape wide wgt, i(age) j(year)

gen wgt1997 = round(.5*(wgt1996+wgt1998))
gen wgt1999 = round(.5*(wgt1998+wgt2000))
gen wgt2001 = round(.5*(wgt2000+wgt2002))
gen wgt2003 = round(.5*(wgt2002+wgt2004))
gen wgt2005 = round(.5*(wgt2004+wgt2006))
gen wgt2007 = round(.5*(wgt2006+wgt2008))
gen wgt2009 = wgt2008

reshape long
sort year age


* Next, construct the weights:
*

tempfile temp1
tempfile temp2

preserve
 keep if year==1987
 egen sum_wgt = total(wgt)
 gen weight = wgt/sum_wgt
 save `temp1'
restore

foreach yr of numlist  1988(1)2009 {
  preserve
    keep if year==`yr'
    egen sum_wgt = total(wgt)
    gen weight = wgt/sum_wgt
    save `temp2', replace
    use `temp1', clear
    append using `temp2'
    save `temp1', replace
  restore
}

use `temp1', clear

keep year age weight
rename age PE

sort year PE

saveold ./weights_PSID/weights_psid_`var'.dta, replace







